/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.client.render.clothes;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.client.render.clothes.ClothesModel;
import com.github.mim1q.convenientdecor.item.ColoredItem;
import com.github.mim1q.convenientdecor.item.RainBootsItem;
import com.github.mim1q.convenientdecor.item.RainHatItem;
import com.github.mim1q.convenientdecor.item.RaincoatItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class RaincoatModel
extends ClothesModel {
    public static final Map<DyeColor, ResourceLocation> TEXTURES = new HashMap<DyeColor, ResourceLocation>();
    private final ModelPart hood;
    private final ModelPart hood2;
    private final ModelPart hat;

    public RaincoatModel(ModelPart root) {
        super(root);
        this.hood = this.head.m_171324_("hood");
        this.hood2 = this.head.m_171324_("hood2");
        this.hat = this.head.m_171324_("hat");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("hood", CubeListBuilder.m_171558_().m_171514_(28, 11).m_171488_(-4.5f, -32.5f, -4.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        head.m_171599_("hood2", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-4.5f, -3.5f, -0.5f, 9.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(9, 46).m_171488_(-4.5f, 0.0f, -4.5f, 9.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(12, 36).m_171488_(-4.0f, -2.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.15f)), PartPose.m_171423_((float)0.0f, (float)-6.75f, (float)-0.025f, (float)-0.07f, (float)0.0f, (float)0.0f));
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.5f, -0.5f, -2.5f, 9.0f, 12.0f, 5.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("backFlap_r1", CubeListBuilder.m_171558_().m_171514_(40, 29).m_171488_(-4.5f, -13.5f, 0.5f, 9.0f, 5.0f, 2.0f, new CubeDeformation(0.09f)), PartPose.m_171423_((float)0.0f, (float)24.25f, (float)2.2f, (float)0.1745f, (float)0.0f, (float)0.0f));
        body.m_171599_("frontFlap_r1", CubeListBuilder.m_171558_().m_171514_(18, 29).m_171488_(-4.5f, -1.0f, 0.0f, 9.0f, 5.0f, 2.0f, new CubeDeformation(0.09f)), PartPose.m_171423_((float)0.0f, (float)11.5f, (float)-2.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = modelPartData.m_171599_("leftArm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        leftArm.m_171599_("leftArm_r1", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171480_().m_171488_(-3.5f, -0.25f, -2.25f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-2.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightArm = modelPartData.m_171599_("rightArm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        rightArm.m_171599_("rightArm_r1", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-1.5f, -0.25f, -2.25f, 5.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-2.5f, (float)-0.25f, (float)0.0f, (float)0.0f, (float)0.1745f));
        modelPartData.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-2.0f, 4.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.1f)).m_171514_(0, 55).m_171488_(-2.0f, 9.0f, -3.2f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        modelPartData.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-2.0f, 4.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.11f)).m_171514_(0, 59).m_171488_(-2.0f, 9.0f, -3.2f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.11f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    @Override
    public void applyTransform(LivingEntity entity, HumanoidModel<?> model, ItemStack stack) {
        super.applyTransform(entity, model, stack);
        this.hat.f_104207_ = false;
        this.hood.f_104207_ = false;
        this.hood2.f_104207_ = false;
        this.body.f_104207_ = false;
        this.leftArm.f_104207_ = false;
        this.rightArm.f_104207_ = false;
        this.leftLeg.f_104207_ = false;
        this.rightLeg.f_104207_ = false;
        if (stack.m_41720_() instanceof RaincoatItem) {
            boolean hooded = RaincoatItem.isHooded(stack);
            this.body.f_104207_ = true;
            this.hood.f_104207_ = hooded;
            this.leftArm.f_104207_ = true;
            this.rightArm.f_104207_ = true;
            this.hood2.f_104207_ = !hooded;
            return;
        }
        if (stack.m_41720_() instanceof RainBootsItem) {
            this.leftLeg.f_104207_ = true;
            this.rightLeg.f_104207_ = true;
            return;
        }
        if (stack.m_41720_() instanceof RainHatItem) {
            this.hat.f_104207_ = true;
        }
    }

    @Override
    public ResourceLocation getTexture(ItemStack stack) {
        return TEXTURES.get(((ColoredItem)stack.m_41720_()).getColor());
    }

    static {
        for (DyeColor color : DyeColor.values()) {
            TEXTURES.put(color, ConvenientDecor.id("textures/clothes/raincoat/" + color.m_41065_() + ".png"));
        }
    }
}

